function [comp_LL, Rt, veclRt] = CompositeLLTCopula(theta,data,corrspec,optimizer,method)

%Calculates the composite likelihood of the DCC assuming t - copula with
%equal dof parameter for all pairs

% IMPUTS:
% theta:            Vector of parameters. 
% data:             matrix of U(0,1) or iid margins
% corrspec:         String with values 'DCC', 'TVC, or 'Patton'
% optimizer:        String with values 'fmincon' or 'fminunc'
% method:           String with values 'CML' or 'IFM'

% OUTPUTS:
% comp_LL:    The composite likelihood 
% Rt:         3d array of dynamic correlations
% veclRt:     Matrix with columns the dynamic correlations from every pair.
%             Helps in plotting

%Author: Manthos Vogiatzoglou, U.o.M. 2008
%-------------------------------------------------------------------------
if nargin==4
    method='CML';
end
if nargin==3
    method='CML'; optimizer='fmincon';
end
if strcmp(corrspec,'fminunc')==1
nu=2+exp(theta(1));
else
nu=theta(1);
end

if min(min(data))<0 || max(max(data))>1
if strcmp(method,'IFM')==1
   trdata=tinv(tcdf(data,nu),nu);
elseif strcmp(method,'CML')==1
    trdata=tinv(empiricalCDF(data),nu);
end
else
    trdata=tinv(data,nu);
end
[T,N]=size(data);
if strcmp(optimizer,'fmincon')==1
if strcmp(corrspec,'DCC')==1 
    [Rt, veclRt]=DCCeq(theta(2:end),trdata);
elseif strcmp(corrspec,'TVC')==1
    [Rt, veclRt]=TVCeq(theta(2:end),trdata);
elseif strcmp(corrspec,'Patton')==1 && N==2
    [Rt, veclRt]=Pattoneq(theta(2:end),data);
elseif strcmp(corrspec,'Patton')==1 && N>2
    display('Patton eq is for bivariate data only. DCC is loaded')
    [Rt, veclRt]=DCCeq(theta(2:end),trdata);
end
elseif strcmp(optimizer,'fminunc')==1
if strcmp(corrspec,'DCC')==1 
    [Rt, veclRt]=DCCeq(theta(2:end),trdata,optimizer);
elseif strcmp(corrspec,'TVC')==1
    [Rt, veclRt]=TVCeq(theta(2:end),trdata,optimizer);
elseif strcmp(corrspec,'Patton')==1 && N==2
    [Rt, veclRt]=Pattoneq(theta(2:end),data);
elseif strcmp(corrspec,'Patton')==1 && N>2
    display('Patton eq is for bivariate data only. DCC is loaded')
    [Rt, veclRt]=DCCeq(theta(2:end),trdata,optimizer);
end  
end
%%%----------------------------------
[T,N]=size(data);
xylik=zeros(T,N*(N-1)/2); % 4 the CL estimation
ssquares=zeros(T,N*(N-1)/2); % 4 the CL estimation
xsq=zeros(T,N*(N-1)/2); ysq=zeros(T,N*(N-1)/2);
counter=0;
for i=1:N
    for j=(i+1):N
    counter=counter+1;
    x = trdata(:,i);
    y = trdata(:,j);
    xylik(:,counter)=x.*y;
    ssquares(:,counter)=x.^2+y.^2;
    xsq(:,counter)=x.^2;
    ysq(:,counter)=y.^2;
    end
end

CL = gammaln((nu+2)/2) + gammaln(nu/2) - 2*gammaln((nu+1)/2) - 0.5*log((1-veclRt.^2));
CL = CL - (nu+2)/2*log(1+(ssquares - 2*veclRt.*xylik)./(nu*(1-veclRt.^2)));
CL = CL + (nu+1)/2*(log(1+xsq/nu) + log(1+ysq/nu));
likelihoods = sum(CL);
likelihoods= -likelihoods;
comp_LL= mean(likelihoods);